<?php

function Recognizer(string $data) : string {

$url = $data;

if (preg_match("/^(?:https?:\/\/)?(?:www\.)?([a-zA-Z0-9.-]+)\.([a-zA-Z]{2,})(?:\/|$)/", $url, $matches)) {
    
    $dominio = $matches[1] . '.' . $matches[2];
    if(substr_count($matches[0], "www.")){
    $dominio = "www.".$matches[1] . '.' . $matches[2];
    }
    
    return $dominio;
} else {
    die("No Domain Found!");
}

}

function Kill(bool $status, string $response, string $reason){
    
    
die(
    json_encode(
                    [
                    "status" => $status,
                    "result" => $response,
                    "reason" => $reason
                    
                        ], JSON_PRETTY_PRINT
                )
    );

}

function getProduct($url){


$url = "https://$url/products.json";

$data = CurlX::Get($url)->body;


$products = json_decode($data, true);
#print_r($products);
if ($products === null) {
     Kill(false, "Failed Search.", "There was a problem in the stock searcher, retry this make\nIf the problem persist change the site or contact Owner!");
}

$lowestCargo = null;
$lowestPrice = PHP_INT_MAX;

foreach ($products['products'] as $product) {
    if (isset($product['variants']) && is_array($product['variants'])) {
        foreach ($product['variants'] as $variant) {
            if ($variant['available'] === true && $variant['requires_shipping'] === true && isset($variant['price']) && $variant['price'] > 0) {
                $price = (float) $variant['price'];
                if ($price < $lowestPrice) {
                    $lowestPrice = $price;
                    $lowestCargo = $variant;
                }
            }
        }
    } else {
        if ($product['available'] === true && $product['requires_shipping'] === true && isset($product['price'])) {
            $price = (float) $product['price'];
            if ($price < $lowestPrice) {
                $lowestPrice = $price;
                $lowestCargo = $product;
            }
        }
    }
}

if ($lowestCargo !== null) {
   $ProductID = $lowestCargo['id'];
}

return (object) ["id" => $ProductID, "Price" => $lowestPrice];
}



function HasCaptcha($HTML){

if(substr_count($HTML, 'g-recaptcha-nojs')){
Kill(false, "Post FAILED!", "reCaptcha/HCaptcha Has Been Detected, Retry this Check or change site!");
}

}